# Description

This sample demonstrates how to integrate **Mobile Orchestration SDK** on an Android device
so as to interact with **OneSpan Adaptive Authentication Service**.

The provided features are :
1. Activation
2. Multi Users Management
3. Notification Registration
4. Local Authentication
5. Local Transaction
6. Remote Authentication (by notification)
7. Remote Transaction (by notification)
8. Change Password
9. Get Activation Information
10. Generate CDDC

User authentication methods available :
- No Protection
- Password Protection (the sample show the external user password authentication)
- Biometric Protection

# Prerequisites

Before running, you need to customize Constants.java :

1. Move to directory `app/src/main/java/com/vasco/orchestration/sample/` and open `Constants.java`

2. Replace the values below :

| Key                                  | Value
|:------------------------------------ |:---------------:
| `ACCOUNT_IDENTIFIER`                 | Identifier of your Onespan Developer Account as defined during your account creation on the [OneSpan Developer Portal](https://community.onespan.com/products/intelligent-adaptive-authentication/getting-started). Indicated as "Sandbox user"
| `SALT_STORAGE` & `SALT_DIGIPASS`     | Two different random strings of 64 hexadecimal characters
| `CLOUD_SERVER_URL`                   | String value representing the domain address starting with a dot for example: `.sdb.tid.onespan.cloud`

- Put google-services.json from your application on Firebase console to module folder /app

# Build and run

## In Android Studio

It can be directly build and run with **Android Studio IDE**

## In your Terminal

- Set your variable environment `ANDROID_HOME`
- Type `./gradlew assembleDebug`

> **Note:** In case of "Permission denied" exception, use **chmod 755 gradlew**

- Move to directory `app/build/outputs/apk/`
- Plug an Android device to your computer
- Verify that your device is attached with `adb devices`
- Type `adb install app-debug.apk`


# How to use
## Sample Configuration

1. Go to [OneSpan Developer Portal](https://community.onespan.com/products/intelligent-adaptive-authentication/getting-started)
2. "Login" or "register an account" using the "Sign Up"
3. Go to your sandbox page
4. Click on the "Update app" button to open the "Register My App" window
5. In this window you can:
    - define your App Identifier: if your are also using iOS it should be the bundle identifier of the iOS project.
    - upload an Android Configuration File or provide a Messaging Server Key
6. Inside the Android sample, update the `Constants.java file like indicated in the prerequisites section.
7. Build and run with **Android Studio**

## Registration
To activate an account you will need two things:
- User Identifier, chosen by the end user
- Activation Password, given by the server

1. Go to your sandbox page
2. Open the **Adaptive Authentication interactive API** link
3. Open `User>users/register` end point.
4. Click on `Try it out`
5. Inside the `Request body` change the `userID` by your own.
6. Click on `Execute`.
7. Retrive the `activationPassword` from the `Response body`
8. Open the mobile application.
9. Click on `Start Activation`.
10. Use the same `User ID` as before, and the `Activation Password` retrieved earlier
11. Click on `Register`
12. Choose a password

Now you should see all the functionalities available with Orchestration.

## Remote Authentication
**Prerequisite**:
Register a device with push notification properly registered.

**Process**:

***Platform API***
1. Go back to the **Platform API Sandbox** (or Adaptive Authentication interactive API)
2. Open the `User>/users/{userID@domain}/login`
3. Click on `Try it out`
4. Enter your `userID` and your `domain` (Sandbox user) in the field `userID@domain`. Do not forget to insert a '@' between them
5. You need to change the Request body by the following:
```
{
    "objectType": "LoginInput",
    "credentials": { "passKey": "PIN"
    },
    "orchestrationDelivery": ["pushNotification"]
}
```

This will send a push notification to the mobile application.

***Mobile Application***
- A click on the notification will display the Login Activity
- The Login Activity is displayed with 2 buttons: accept / reject.
- In both case :
    1. The user authentication method pushed by **OneSpan Adaptive Authentication Service** is applied.
    2. Upon Success, a command is generated and sent to the server to inform of end user choice.
    3. A message is displayed on your device to inform you that the server correctly receive your message.
